# --------------------     FARESPCB  --------------------
# ---------  Raspberry Pi Pico Development Kit  ---------
# --------------------  OLED Test Code  -----------------
from machine import Pin, I2C
from ssd1306 import SSD1306_I2C
import time
WIDTH =128 
HEIGHT= 64
i2c=I2C(0,scl=Pin(17),sda=Pin(16),freq=200000)
oled = SSD1306_I2C(WIDTH,HEIGHT,i2c)

def lines():
    for i in range (0,64,5):
        oled.line(0,0,128,i,1)
        oled.show()
    for i in range (128,0,-5):
        oled.line(0,0,i,64,1)
        oled.show()
        
def rectangles():
    x=0;y=0
    for i in range(34):
        oled.rect(0,0,x,y,1);oled.show()
        x+=4
        y+=2
  
lines()
oled.fill(0)
time.sleep(0.5)
rectangles()
oled.fill(0)
time.sleep(0.5)

while True:
    oled.fill(0)
    oled.text(" ** FARESPCB ** ", 0, 0)
    oled.text("  Raspberry Pi  ", 0, 20)
    oled.text("  Pico Dev Kit  ", 0, 30)
    oled.text("  128X64 OLED   ", 0, 50)
    oled.show()